/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWUserInfo;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.dialog.VWConfirmYesNoDialog;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.uicontrols.border.VWTitledBorder;
import filenet.vw.toolkit.utils.uicontrols.security.IVWRecipientSelectionPanel;
import filenet.vw.toolkit.utils.uicontrols.security.VWRecipientComboPanel;
import filenet.vw.toolkit.utils.uicontrols.security.VWRecipientFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VWAdminOutOfOfficeDialog
extends VWModalDialog
implements IVWFrameInterface,
ActionListener,
FocusListener {
    private VWAdminResultPane m_resultsPane = null;
    private VWSession m_vwSession = null;
    private Frame m_parentFrame = null;
    private JButton m_okButton = null;
    private JButton m_applyButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private boolean m_bCanceled = true;
    private boolean m_bLocked = false;
    private IVWRecipientSelectionPanel m_outOfOfficePersonPanel = null;
    private JCheckBox m_outOfOfficeCheckBox = null;
    private IVWRecipientSelectionPanel m_selectedRecipientPanel = null;
    private VWUserInfo m_userInfo = null;

    public VWAdminOutOfOfficeDialog(VWAdminResultPane resultsPane) {
        super(resultsPane.getParentFrame());
        this.m_parentFrame = resultsPane.getParentFrame();
        this.m_vwSession = resultsPane.getSession();
        this.m_resultsPane = resultsPane;
        this.getContentPane().setLayout(new BorderLayout(6, 6));
        Dimension dim = VWStringUtils.stringToDimension("495,335");
        if (dim == null) {
            dim = new Dimension(450, 300);
        }
        try {
            if (this.m_vwSession.getSecurityDatabaseType() == 1) {
                dim = new Dimension(dim.width, (int)((double)dim.height * 1.5));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.setSize(dim);
        this.setTitle(VWResource.s_outOfOfficeTitle);
        this.setVisible(false);
        this.setLocationRelativeTo(this.m_parentFrame);
        this.getContentPane().add((Component)this.createMainPanel(), "Center");
        this.getContentPane().add((Component)this.createButtonPanel(), "Last");
        this.initialState();
        this.addWindowListener(new VWWindowAdapter(this));
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_outOfOfficePersonPanel)) {
            this.getUserInfoRecord();
            this.updateControls();
        } else if (event.getSource().equals(this.m_outOfOfficeCheckBox)) {
            this.resetSelectedPersonCombo(null);
        } else if (event.getSource().equals(this.m_selectedRecipientPanel)) {
            this.setButtonState();
        } else if (event.getSource().equals(this.m_okButton)) {
            this.m_bCanceled = false;
            if (this.doAssign()) {
                this.setVisible(false);
            }
        } else if (event.getSource().equals(this.m_applyButton)) {
            boolean bIsOkay = this.doAssign();
            this.m_applyButton.setEnabled(!bIsOkay);
            if (bIsOkay) {
                this.initialState();
            } else {
                this.m_selectedRecipientPanel.reset();
                this.setButtonState();
            }
        } else if (event.getSource().equals(this.m_cancelButton)) {
            this.m_bCanceled = true;
            this.setVisible(false);
        } else if (event.getSource().equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_Process_Admin + "bpfah035.htm");
        }
    }

    public void windowClosing(WindowEvent event) {
        this.m_bCanceled = true;
        super.windowClosing(event);
    }

    protected boolean getStatus() {
        return this.m_bCanceled;
    }

    private JPanel createMainPanel() {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            mainPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 5);
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 23;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 0.5;
            mainPanel.add((Component)this.getOutOfOfficePersonPanel(), c);
            c.insets = new Insets(5, 2, 10, 5);
            ++c.gridy;
            mainPanel.add((Component)this.getOutOfOfficeSettingPanel(), c);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getOutOfOfficePersonPanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(2, 2, 2, 5);
            c.anchor = 23;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.fill = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            JLabel selectLabel = new JLabel(VWResource.s_selectOutOfOficePerson);
            selectLabel.setBorder(null);
            selectLabel.setFocusable(true);
            selectLabel.addFocusListener(this);
            VWAccessibilityHelper.setAccessibility(selectLabel, this, VWResource.s_selectOutOfOficePerson, VWResource.s_selectOutOfOficePerson);
            panel.add((Component)selectLabel, c);
            this.m_outOfOfficePersonPanel = this.m_vwSession.getSecurityDatabaseType() == 1 ? new VWRecipientFilterPanel(this, this.m_vwSession) : new VWRecipientComboPanel(this, this.m_vwSession);
            this.m_outOfOfficePersonPanel.reset();
            this.m_outOfOfficePersonPanel.addActionListener(this);
            c.insets = new Insets(5, 2, 5, 5);
            ++c.gridy;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            panel.add((Component)((JPanel)((Object)this.m_outOfOfficePersonPanel)), c);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getOutOfOfficeSettingPanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(new VWTitledBorder(VWResource.s_outOfOfficeSettings));
            VWAccessibilityHelper.setAccessibility(panel, this, VWResource.s_outOfOfficeSettings, VWResource.s_outOfOfficeSettings);
            this.m_outOfOfficeCheckBox = new JCheckBox(VWResource.s_iAmOutOfOfice);
            VWAccessibilityHelper.setAccessibility(this.m_outOfOfficeCheckBox, this, VWResource.s_iAmOutOfOfice, VWResource.s_iAmOutOfOfice);
            this.m_outOfOfficeCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_outOfOfficeCheckBox.addActionListener(this);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(0, 5, 6, 5);
            c.anchor = 23;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            panel.add((Component)this.m_outOfOfficeCheckBox, c);
            c.insets = new Insets(5, 5, 5, 5);
            ++c.gridy;
            c.fill = 1;
            JLabel m_selectPersonToReceiveLabel = new JLabel(VWResource.s_selectPersonToReceiveWork);
            m_selectPersonToReceiveLabel.setBorder(null);
            m_selectPersonToReceiveLabel.setFocusable(true);
            m_selectPersonToReceiveLabel.addFocusListener(this);
            VWAccessibilityHelper.setAccessibility(m_selectPersonToReceiveLabel, this, VWResource.s_selectPersonToReceiveWork, VWResource.s_selectPersonToReceiveWork);
            panel.add((Component)m_selectPersonToReceiveLabel, c);
            this.m_selectedRecipientPanel = this.m_vwSession.getSecurityDatabaseType() == 1 ? new VWRecipientFilterPanel(this, this.m_vwSession) : new VWRecipientComboPanel(this, this.m_vwSession);
            this.m_selectedRecipientPanel.reset();
            this.m_selectedRecipientPanel.addActionListener(this);
            c.insets = new Insets(2, 5, 5, 5);
            ++c.gridy;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            panel.add((Component)((JPanel)((Object)this.m_selectedRecipientPanel)), c);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(1, 2, 6, 6);
            this.m_okButton = new JButton(VWResource.s_OK);
            this.m_okButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_okButton, this, VWResource.s_OK, VWResource.s_OK);
            this.m_okButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_okButton, gbCons);
            ++gbCons.gridx;
            this.m_applyButton = new JButton(VWResource.s_apply);
            this.m_applyButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_applyButton, this, VWResource.s_apply, VWResource.s_apply);
            this.m_applyButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_applyButton, gbCons);
            ++gbCons.gridx;
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.s_cancel, VWResource.s_cancel);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_cancelButton, gbCons);
            ++gbCons.gridx;
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.s_help, VWResource.s_help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add((Component)this.m_helpButton, gbCons);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void disableControls() {
        this.m_selectedRecipientPanel.setEnabled(false);
        this.m_outOfOfficeCheckBox.setEnabled(false);
        this.m_applyButton.setEnabled(false);
        this.m_okButton.setEnabled(false);
    }

    private void getUserInfoRecord() {
        if (this.m_outOfOfficePersonPanel.hasValidSelection()) {
            try {
                VWParticipant selectedUser = this.m_outOfOfficePersonPanel.getSelectedValue();
                this.m_userInfo = this.m_vwSession.fetchUserInfo(selectedUser.getParticipantName());
            }
            catch (Exception ex) {
                this.m_userInfo = null;
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this, ex.getLocalizedMessage(), 1);
            }
        } else {
            this.m_userInfo = null;
        }
    }

    private void updateControls() {
        this.updateOutOfOfficeSetting();
        this.setButtonState();
    }

    private void setButtonState() {
        boolean bEnable = false;
        if (this.m_outOfOfficePersonPanel.hasValidSelection()) {
            if (this.m_outOfOfficeCheckBox.isSelected()) {
                if (this.m_selectedRecipientPanel.hasValidSelection()) {
                    bEnable = true;
                }
            } else {
                bEnable = true;
            }
        }
        this.m_applyButton.setEnabled(bEnable);
        this.m_okButton.setEnabled(bEnable);
    }

    private void updateOutOfOfficeSetting() {
        if (this.m_outOfOfficePersonPanel.hasValidSelection() && this.m_userInfo != null) {
            try {
                boolean isOutOfOffice = false;
                VWParticipant assignee = null;
                try {
                    assignee = this.m_userInfo.getProxyUserNamePx();
                    isOutOfOffice = assignee != null;
                }
                catch (Exception ex) {
                    isOutOfOffice = false;
                    assignee = null;
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this, ex.getLocalizedMessage(), 1);
                }
                if (this.m_outOfOfficeCheckBox != null) {
                    this.m_outOfOfficeCheckBox.setEnabled(true);
                    this.m_outOfOfficeCheckBox.setSelected(isOutOfOffice);
                    this.resetSelectedPersonCombo(assignee);
                }
            }
            catch (Exception ex) {
                this.disableControls();
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this, ex.getLocalizedMessage(), 1);
            }
        } else {
            this.disableControls();
        }
    }

    private boolean doAssign() {
        boolean isOkay;
        block8: {
            isOkay = true;
            try {
                if (this.m_userInfo == null) break block8;
                if (this.m_outOfOfficeCheckBox.isSelected() && this.m_selectedRecipientPanel.hasValidSelection()) {
                    VWParticipant selectedUser = this.m_selectedRecipientPanel.getSelectedValue();
                    try {
                        VWUserInfo selectedUserInfo = this.m_vwSession.fetchUserInfo(selectedUser.getParticipantName());
                        if (selectedUserInfo.getProxyUserName() != null) {
                            VWConfirmYesNoDialog dlg = new VWConfirmYesNoDialog(this.m_parentFrame, VWResource.s_outOfOfficeTitle, VWResource.s_confirmAssign, 0);
                            dlg.setVisible(true);
                            if (!dlg.isYes()) {
                                isOkay = false;
                                return isOkay;
                            }
                        }
                        this.m_userInfo.setProxyUserNameByDomain(selectedUser.getDomainName(), selectedUser.getParticipantName());
                        this.m_userInfo.save();
                        break block8;
                    }
                    catch (VWException ex) {
                        VWDebug.logException(ex);
                        VWMessageDialog.showOptionDialog(this, ex.getLocalizedMessage(), 1);
                        return false;
                    }
                }
                if (!this.m_outOfOfficeCheckBox.isSelected()) {
                    this.m_userInfo.setProxyUserName(null);
                    this.m_userInfo.save();
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this, ex.getLocalizedMessage(), 1);
                return false;
            }
        }
        return isOkay;
    }

    private void resetSelectedPersonCombo(VWParticipant assignee) {
        this.m_selectedRecipientPanel.reset();
        if (this.m_outOfOfficeCheckBox.isSelected()) {
            this.m_selectedRecipientPanel.setEnabled(true);
        } else {
            this.m_selectedRecipientPanel.setEnabled(false);
        }
        this.m_selectedRecipientPanel.setSelectedValue(assignee);
        this.setButtonState();
    }

    private void initialState() {
        this.m_outOfOfficePersonPanel.reset();
        this.m_selectedRecipientPanel.reset();
        this.m_outOfOfficeCheckBox.setSelected(false);
        this.disableControls();
    }

    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source instanceof JTextField && !((JTextField)source).isEditable()) {
            ((JTextField)source).setBorder(BorderFactory.createEtchedBorder());
        }
    }

    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        if (source instanceof JTextField && !((JTextField)source).isEditable()) {
            ((JTextField)source).setBorder(null);
        }
    }
}

